
 
 IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_PG_FORN_AUDIT' AND TYPE = 'TR')
BEGIN
	DROP TRIGGER DBO.TRG_PG_FORN_AUDIT 
END
GO
 
CREATE TRIGGER [DBO].TRG_PG_FORN_AUDIT ON [DBO].PG_FORN 
FOR UPDATE
AS 

BEGIN TRY
 
BEGIN

INSERT INTO PG_FORN_AUDIT
	(  CD_EMP
	  ,CD_FILIAL
	  ,CD_FORN
	  ,RZ_FORN
	  ,NM_FANT
	  ,CD_CID
	  ,END_FORN
	  ,BAIRRO_FORN
	  ,DT_CAD_AUDIT
	  ,CD_USU
	  ,DT_CAD 
	  )
SELECT 
	 d.CD_EMP
	,d.CD_FILIAL
	,d.CD_FORN
	,d.RZ_FORN
	,d.NM_FANT
	,d.CD_CID
	,d.END_FORN
	,d.BAIRRO_FORN
	,GETDATE() DT_CAD_AUDIT
	,d.CD_USU
	,d.DT_CAD 
FROM 
	DELETED D 
	INNER JOIN INSERTED I ON (D.CD_EMP	     <> I.CD_EMP OR
							  D.CD_FILIAL    <> I.CD_FILIAL OR
							  D.CD_FORN      <> I.CD_FORN OR
							  D.RZ_FORN      <> I.RZ_FORN OR
							  D.NM_FANT      <> I.NM_FANT OR
							  D.CD_CID       <> I.CD_CID OR 
							  D.END_FORN     <> I.END_FORN OR 
							  D.BAIRRO_FORN  <> I.BAIRRO_FORN OR 
							  D.CD_USU       <> I.CD_USU OR
							  D.DT_CAD       <> I.DT_CAD  )	 
END	
END TRY
BEGIN CATCH 
	DECLARE @ERRO VARCHAR (500) = ERROR_MESSAGE();
	
	INSERT INTO ADM_ERRO (NUMERO, SEVERIDADE, ESTADO, ROTINA, LINHA, MENSAGEM, DTERRO)
		SELECT
			ERROR_NUMBER() AS NUMERO,
			ERROR_SEVERITY() AS SEVERIDADE,
			ERROR_STATE() AS ESTADO,
			ERROR_PROCEDURE() AS ROTINA,
			ERROR_LINE() AS LINHA,
			ERROR_MESSAGE() AS MENSAGEM,
			GETDATE() AS DTERRO;
	   RAISERROR (@ERRO,16, 1)	
			
END CATCH
